ORCA/M Asm65816 2.1.0

0001 B93D              ;====================================================================================================
0002 B93D              ;Switch_handler This routine is called when we switch from GS/OS to ProDOS 8 and when we switch
0003 B93D              ;               from ProDOS8 to GS/OS.
0004 B93D              ;
0005 B93D              ;Input:         1 = Switch P8 to GS/OS, 0 = Switch GS/OS to P8
0006 B93D              ;
0007 B93D              ;Output:        A = undefined
0008 B93D              ;               X = undefined
0009 B93D              ;               Y = undefined
0010 B93D              ;               P = nvmxdizc
0011 B93D              ;                   ..000..1 = error
0012 B93D              ;               b = k
0013 B93D              ;
0014 B93D              ;               The Direct page is saved and released if we are switching from GS/OS to P8
0015 B93D              ;               The Direct page is allocated and restored if we are switching from P8 to GS/OS
0016 B93D              ;
0017 B93D              ;====================================================================================================
0018 B93D
0019 B93D                       longa on
0020 B93D                       longi on
0021 B93D              Switch_handler proc 
0022 B93D                       LoadSegCheck 
0023 B93D
0024 B93D                       with DirectPage, Globals
0025 B93D
0026 B93D                       Import clear_handles, alloc_my_dp
0027 B93D
0028 B93D              function equ   7
0029 B93D
0030 B93D A3 07                 lda   function,s               ;get the input parameter
0031 B93F AA                    tax                            ;save in X for a minute
0032 B940 A3 05                 lda   5,s                      ;remove input parameter from stack
0033 B942 83 07                 sta   7,s                      ;by moving two return addresses up
0034 B944 A3 03                 lda   3,s
0035 B946 83 05                 sta   5,s
0036 B948 68                    pla   
0037 B949 83 01                 sta   1,s
0038 B94B
0039 B94B 8B                    phb   
0040 B94C 4B                    phk                            ;set our data bank register
0041 B94D AB                    plb   
0042 B94E 0B                    phd                            ;save caller's direct page
0043 B94F
0044 B94F 8A                    txa                            ;check the input parameter
0045 B950 D0 2A                 bne   @restore_dp              ;goin' back to GS/OS
0046 B952
0047 B952 AD 92 A6              lda   Globals.my_dir_page      ;setup our own direct page
0048 B955 5B                    tcd   
0049 B956
0050 B956 A2 E8 00              ldx   #dir_page_size-2         ;save the direct page please
0051 B959 B5 00        @save_loop lda   00,x
0052 B95B 9D AA A7              sta   dir_page_buffer,x
0053 B95E CA                    dex   
0054 B95F CA                    dex   
0055 B960 10 F7                 bpl   @save_loop
0056 B962
0057 B962 AD 90 A6              lda   dp_handle+2              ;dispose the handle
0058 B965 48                    pha   
0059 B966 AD 8E A6              lda   dp_handle
0060 B969 48                    pha   
0061 B96A 20 00 D0              jsr   clear_handles            ;clear local copy of handle
0062 B96D A2 02 10 22           _DisposeHandle 
0063 B974 9C 8E A6              stz   dp_handle
0064 B977 9C 90 A6              stz   dp_handle+2
0065 B97A 80 11                 bra   no_errors
0066 B97C
0067 B97C              @restore_dp  
0068 B97C 20 6F D0              jsr   alloc_my_dp              ;allocate me a direct page please
0069 B97F B0 10                 bcs   error_exit               ;return the error
0070 B981
0071 B981 A2 E8 00              ldx   #dir_page_size-2         ;save the direct page please
0072 B984 BD AA A7     @restore_loop lda   dir_page_buffer,x
0073 B987 95 00                 sta   00,x
0074 B989 CA                    dex   
0075 B98A CA                    dex   
0076 B98B 10 F7                 bpl   @restore_loop
0077 B98D              no_errors  
0078 B98D A9 00 00              lda   #0                       ;no errors
0079 B990 18                    clc   
0080 B991              error_exit  
0081 B991 2B                    pld                            ;restore direct page
0082 B992 AB                    plb                            ;and DBR
0083 B993 6B                    rtl   
0084 B994
0085 B994                       endp 
0086 B994
0087 B994                       TITLE ', ExpressLoad.a - startup'
0088 B994              ;====================================================================================================
0089 B994              ;startup:       This routine will allocate memory used by the system loader and setup
0090 B994              ;               any data structures that are used by ExpressLoad.
0091 B994              ;
0092 B994              ;
0093 B994              ;Input:         A = undefined
0094 B994              ;               X = undefined
0095 B994              ;               Y = undefined
0096 B994              ;               P = nvmxdizc
0097 B994              ;                   ..000...
0098 B994              ;               b = k
0099 B994              ;
0100 B994              ;
0101 B994              ;Output:        A = undefined
0102 B994              ;               X = undefined
0103 B994              ;               Y = undefined
0104 B994              ;               P = nvmxdizc
0105 B994              ;                   ..000..1 = error    ;If this happens I would be suprized
0106 B994              ;               b = k
0107 B994              ;
0108 B994              ;
0109 B994              ;====================================================================================================
0110 B994
0111 B994                       longa on
0112 B994                       longi on
0113 B994              startup  proc 
0114 B994                       LoadSegCheck 
0115 B994
0116 B994                       with DirectPage
0117 B994
0118 B994                       Import alloc_my_dp,add_id_table
0119 B994
0120 B994 E2 20                 sep   #$20                     ;go into 8-bit mode
0121 B996                       longa off
0122 B996 AF 68 C0 E0           lda   >statereg                ;get current language card setting
0123 B99A 48                    pha                            ;save on stack temporarily
0124 B99B AF 8B C0 E0           lda   >$E0C08B                 ;turn language card on
0125 B99F AF 8B C0 E0           lda   >$E0C08B
0126 B9A3 C2 20                 rep   #$20
0127 B9A5                       longa on
0128 B9A5
0129 B9A5 20 6F D0              jsr   alloc_my_dp              ;allocate me a direct page please
0130 B9A8 B0 10                 bcs   @error_exit
0131 B9AA
0132 B9AA A2 00 01              ldx   #256
0133 B9AD              @clear_it  
0134 B9AD CA                    dex   
0135 B9AE CA                    dex   
0136 B9AF 74 00                 stz   DirectPage,x             ;zero out my direct page
0137 B9B1 D0 FA                 bne   @clear_it
0138 B9B3
0139 B9B3 64 78                 stz   user_id_handle           ;indicate that there is no ID table yet
0140 B9B5 64 7A                 stz   user_id_handle+2
0141 B9B7              ;
0142 B9B7              ;Now lets setup one user_id_table
0143 B9B7              ;
0144 B9B7 20 45 D1              jsr   add_id_table             ;add the first User ID Table please
0145 B9BA              @error_exit  
0146 B9BA AA                    tax                            ;save any possible error code
0147 B9BB E2 20                 sep   #$20                     ;8-bit accumulator
0148 B9BD                       longa off
0149 B9BD 68                    pla                            ;retrieve saved language card state
0150 B9BE 8F 68 C0 E0           sta   >statereg                ;restore it
0151 B9C2 C2 20                 rep   #$20
0152 B9C4                       longa on
0153 B9C4 8A                    txa                            ;retrieve possible error code
0154 B9C5 60                    rts                            ;return the error code to caller
0155 B9C6                       endp 
0156 B9C6
0157 B9C6                       TITLE ', ExpressLoad.a - get_parameters'
0158 B9C6              ;====================================================================================================
0159 B9C6              ;get_parameters:        This routine is called at the beginning of each Tool call.  It will
0160 B9C6              ;                       get the input parameters off the stack and setup our operating environment.
0161 B9C6              ;
0162 B9C6              ;
0163 B9C6              ;Input:         A = undefined
0164 B9C6              ;               X = number of paramters on stack
0165 B9C6              ;               Y = undefined
0166 B9C6              ;               P = nvmxdizc
0167 B9C6              ;                   ..000...
0168 B9C6              ;               b = ?
0169 B9C6              ;
0170 B9C6              ;
0171 B9C6              ;Output:        A = undefined
0172 B9C6              ;               X = undefined
0173 B9C6              ;               Y = undefined
0174 B9C6              ;               P = nvmxdizc
0175 B9C6              ;                   ..000...
0176 B9C6              ;               b = k
0177 B9C6              ;
0178 B9C6              ;
0179 B9C6              ;====================================================================================================
0180 B9C6
0181 B9C6                       longa on
0182 B9C6                       longi on
0183 B9C6              get_parameters proc 
0184 B9C6                       LoadSegCheck 
0185 B9C6
0186 B9C6                       with DirectPage, Globals
0187 B9C6                       Import zero_handles,reset_local_mark
0188 B9C6
0189 B9C6              ;
0190 B9C6              ;Save the data bank register
0191 B9C6              ;
0192 B9C6 8B                    phb   
0193 B9C7 8B                    phb                            ;save the bank register first
0194 B9C8 68                    pla   
0195 B9C9              ;
0196 B9C9              ;Set data bank register to our bank
0197 B9C9              ;
0198 B9C9 4B                    phk   
0199 B9CA AB                    plb                            ;set data bank to our bank.
0200 B9CB 8D 9C A6              sta   data_bank                ;save caller's DBR
0201 B9CE              ;
0202 B9CE              ;Save the return address
0203 B9CE              ;
0204 B9CE 68                    pla                            ;save RTS
0205 B9CF 8D 19 BA              sta   local_return
0206 B9D2
0207 B9D2              ;
0208 B9D2              ;save the app's direct page
0209 B9D2              ;
0210 B9D2 7B                    tdc                            ;save the direct page register
0211 B9D3 8D 9A A6              sta   apps_dir_page
0212 B9D6              ;
0213 B9D6              ;setup our direct page
0214 B9D6              ;
0215 B9D6 AD 92 A6              lda   my_dir_page
0216 B9D9 5B                    tcd                            ;we now have our own direct page
0217 B9DA
0218 B9DA              ;
0219 B9DA              ;save the return address
0220 B9DA              ;
0221 B9DA 68                    pla                            ;now save the return address
0222 B9DB 8D 94 A6              sta   return_addr
0223 B9DE 68                    pla                            ;get both return address off the stack
0224 B9DF 8D 96 A6              sta   return_addr+2
0225 B9E2 68                    pla   
0226 B9E3 8D 98 A6              sta   return_addr+4
0227 B9E6
0228 B9E6 DA                    phx                            ;save the # of input parameters
0229 B9E7
0230 B9E7 22 64 00 E1           jsl   incbusyflg               ;don't let nobody bother us!
0231 B9EB
0232 B9EB              ;
0233 B9EB              ; enable the language card memory
0234 B9EB              ;
0235 B9EB E2 20                 sep   #$20                     ;8-bit soft-switch access
0236 B9ED                       longa off
0237 B9ED AF 68 C0 E0           lda   >statereg                ;get the current setting
0238 B9F1 85 D2                 sta   save_statereg
0239 B9F3 AF 8B C0 E0           lda   >$E0C08B                 ;turn language card on
0240 B9F7 AF 8B C0 E0           lda   >$E0C08B
0241 B9FB C2 20                 rep   #$20
0242 B9FD                       longa on
0243 B9FD
0244 B9FD 7A                    ply                            ;retrieve the # of input parameters
0245 B9FE F0 0C                 beq   @done                    ;we have done our job
0246 BA00              ;
0247 BA00              ;now we need to pull the needed parameters off of the stack.
0248 BA00              ;
0249 BA00 A2 00 00              ldx   #$0000
0250 BA03              @loop     
0251 BA03 68                    pla                            ;get a byte off the stack
0252 BA04 95 E0                 sta   input_parms,x            ;save the byte in a common parameter block
0253 BA06 E8                    inx   
0254 BA07 E8                    inx   
0255 BA08 88                    dey   
0256 BA09 88                    dey   
0257 BA0A D0 F7                 bne   @loop
0258 BA0C              @done     
0259 BA0C AD 19 BA              lda   local_return
0260 BA0F 48                    pha   
0261 BA10 20 EE E4              jsr   zero_handles
0262 BA13 20 C0 D1              jsr   reset_local_mark
0263 BA16 64 A4                 stz   partial_match            ;indicate that we need a complete match!!!
0264 BA18
0265 BA18 60                    rts   
0266 BA19
0267 BA19 31 B4        local_return DC W:00
0268 BA1B
0269 BA1B                       endp 
0270 BA1B
0271 BA1B                       TITLE ', ExpressLoad.a - return_to_caller'
0272 BA1B              ;====================================================================================================
0273 BA1B              ;return_to_caller:      This routine is called if ExpresssLoad has handled the file
0274 BA1B              ;
0275 BA1B              ;
0276 BA1B              ;Input:         A = undefined
0277 BA1B              ;               X = undefined
0278 BA1B              ;               Y = undefined
0279 BA1B              ;               P = nvmxdizc
0280 BA1B              ;                   ..000..1 = no error
0281 BA1B              ;               b = K
0282 BA1B              ;
0283 BA1B              ;
0284 BA1B              ;Output:        A = undefined
0285 BA1B              ;               X = undefined
0286 BA1B              ;               Y = undefined
0287 BA1B              ;               P = nvmxdizc
0288 BA1B              ;                   ..000...
0289 BA1B              ;               b = k
0290 BA1B              ;
0291 BA1B              ;====================================================================================================
0292 BA1B
0293 BA1B                       longa on
0294 BA1B                       longi on
0295 BA1B              return_to_caller proc  
0296 BA1B                       LoadSegCheck 
0297 BA1B
0298 BA1B                       with DirectPage, Globals
0299 BA1B                       Import close_load_file
0300 BA1B
0301 BA1B 8D 60 BA              sta   local_error
0302 BA1E
0303 BA1E A5 B4                 lda   file_open                ;is the load file open?
0304 BA20 F0 03                 beq   @not_open                ;the file is not open so don't worry about it.
0305 BA22 20 2E DD              jsr   close_load_file          ;go ahead and close the file since we are thru with it.
0306 BA25              @not_open  
0307 BA25 A0 04 00              ldy   #$0004                   ;lets unlock this puppy
0308 BA28 A5 88                 lda   ExpressHandle
0309 BA2A 05 8A                 ora   ExpressHandle+2
0310 BA2C F0 07                 beq   @skip_unlock             ;there is no ExpressSegment
0311 BA2E
0312 BA2E B7 88                 lda   [ExpressHandle],y
0313 BA30 29 FF 7F              and   #$7FFF                   ;unlock the handle
0314 BA33 97 88                 sta   [ExpressHandle],y
0315 BA35
0316 BA35              @skip_unlock  
0317 BA35 E2 20                 sep   #$20                     ;8-bit soft-switch access
0318 BA37                       longa off
0319 BA37 A5 D2                 lda   save_statereg            ;get the original setting
0320 BA39 8F 68 C0 E0           sta   >statereg                ;reset
0321 BA3D C2 20                 rep   #$20
0322 BA3F                       longa on
0323 BA3F
0324 BA3F 22 68 00 E1           jsl   decbusyflg               ;we be done now
0325 BA43
0326 BA43 AD 98 A6              lda   return_addr+4
0327 BA46 48                    pha   
0328 BA47 AD 96 A6              lda   return_addr+2
0329 BA4A 48                    pha   
0330 BA4B AD 94 A6              lda   return_addr
0331 BA4E 48                    pha   
0332 BA4F
0333 BA4F
0334 BA4F AD 9A A6              lda   apps_dir_page
0335 BA52 5B                    tcd                            ;restore the direct page
0336 BA53 AD 9C A6              lda   data_bank
0337 BA56 48                    pha   
0338 BA57 AD 60 BA              lda   local_error
0339 BA5A AB                    plb   
0340 BA5B AB                    plb   
0341 BA5C C9 01 00              cmp   #$0001
0342 BA5F 6B                    rtl   
0343 BA60
0344 BA60 00 00        local_error DC W:00
0345 BA62
0346 BA62                       endp 
0347 BA62
0348 BA62
0349 BA62                       TITLE ', ExpressLoad.a - lock_handles'
0350 BA62              ;====================================================================================================
0351 BA62              ;lock_handles   This routine will save and lock handles used by ExpressLoad
0352 BA62              ;unlock_handles This routine will restore the previous state of the now locked handle
0353 BA62              ;
0354 BA62              ;Input:         A = undefined
0355 BA62              ;               X = undefined
0356 BA62              ;               Y = undefined
0357 BA62              ;               P = nvmxdizc
0358 BA62              ;                   ..000...
0359 BA62              ;               b = k
0360 BA62              ;
0361 BA62              ;
0362 BA62              ;Output:        A = preserved
0363 BA62              ;               X = preserved
0364 BA62              ;               Y = preserved
0365 BA62              ;               P = preserved
0366 BA62              ;               b = k
0367 BA62              ;
0368 BA62              ;
0369 BA62              ;
0370 BA62              ;====================================================================================================
0371 BA62
0372 BA62                       longa on
0373 BA62                       longi on
0374 BA62              lock_handles proc 
0375 BA62                       with DirectPage,Globals
0376 BA62 08                    php                            ;save all registers!
0377 BA63 48                    pha   
0378 BA64 DA                    phx   
0379 BA65 5A                    phy   
0380 BA66
0381 BA66 A0 04 00              ldy   #$0004                   ;lets lock this puppy
0382 BA69 A5 88                 lda   ExpressHandle
0383 BA6B 05 8A                 ora   ExpressHandle+2
0384 BA6D F0 0A                 beq   @skip_express
0385 BA6F
0386 BA6F B7 88                 lda   [ExpressHandle],y
0387 BA71 8D 19 BB              sta   ExpressHndl_flag
0388 BA74 09 00 80              ora   #$8000                   ;lock the handle
0389 BA77 97 88                 sta   [ExpressHandle],y
0390 BA79
0391 BA79              @skip_express  
0392 BA79 A5 78                 lda   user_id_handle           ;lock ID table down
0393 BA7B 05 7A                 ora   user_id_handle+2
0394 BA7D F0 0A                 beq   @skip_ids
0395 BA7F
0396 BA7F B7 78                 lda   [user_id_handle],y
0397 BA81 8D 23 BB              sta   user_id_flag
0398 BA84 09 00 80              ora   #$8000                   ;lock the handle
0399 BA87 97 78                 sta   [user_id_handle],y
0400 BA89              @skip_ids  
0401 BA89 A5 46                 lda   temp_handle
0402 BA8B 05 48                 ora   temp_handle+2
0403 BA8D F0 0A                 beq   @skip_temp
0404 BA8F
0405 BA8F B7 46                 lda   [temp_handle],y
0406 BA91 8D 1B BB              sta   tempHndl_flag
0407 BA94 09 00 80              ora   #$8000                   ;lock the handle
0408 BA97 97 46                 sta   [temp_handle],y
0409 BA99              @skip_temp  
0410 BA99 A5 90                 lda   reloc_handle
0411 BA9B 05 92                 ora   reloc_handle+2
0412 BA9D F0 0A                 beq   @skip_reloc
0413 BA9F
0414 BA9F B7 90                 lda   [reloc_handle],y
0415 BAA1 8D 1D BB              sta   relocHndl_flag
0416 BAA4 09 00 80              ora   #$8000                   ;lock the handle
0417 BAA7 97 90                 sta   [reloc_handle],y
0418 BAA9              @skip_reloc  
0419 BAA9 A5 94                 lda   seg_handle
0420 BAAB 05 96                 ora   seg_handle+2
0421 BAAD F0 0A                 beq   @skip_seg
0422 BAAF
0423 BAAF B7 94                 lda   [seg_handle],y
0424 BAB1 8D 1F BB              sta   segHndl_flag
0425 BAB4 09 00 80              ora   #$8000                   ;lock the handle
0426 BAB7 97 94                 sta   [seg_handle],y
0427 BAB9              @skip_seg  
0428 BAB9 A5 98                 lda   curr_id_handle
0429 BABB 05 9A                 ora   curr_id_handle+2
0430 BABD F0 0A                 beq   @skip_id
0431 BABF
0432 BABF B7 98                 lda   [curr_id_handle],y
0433 BAC1 8D 21 BB              sta   idHndl_flag
0434 BAC4 09 00 80              ora   #$8000                   ;lock the handle
0435 BAC7 97 98                 sta   [curr_id_handle],y
0436 BAC9              @skip_id  
0437 BAC9 80 49                 bra   end_handles
0438 BACB
0439 BACB                       entry unlock_handles
0440 BACB              unlock_handles  
0441 BACB 08                    php                            ;save all registers!
0442 BACC 48                    pha   
0443 BACD DA                    phx   
0444 BACE 5A                    phy   
0445 BACF
0446 BACF
0447 BACF A0 04 00              ldy   #$0004                   ;lets lock this puppy
0448 BAD2 A5 88                 lda   ExpressHandle
0449 BAD4 05 8A                 ora   ExpressHandle+2
0450 BAD6 F0 05                 beq   @skip_express
0451 BAD8
0452 BAD8 AD 19 BB              lda   ExpressHndl_flag         ;restore old state
0453 BADB 97 88                 sta   [ExpressHandle],y
0454 BADD              @skip_express  
0455 BADD A5 46                 lda   temp_handle
0456 BADF 05 48                 ora   temp_handle+2
0457 BAE1 F0 05                 beq   @skip_temp
0458 BAE3
0459 BAE3 AD 1B BB              lda   tempHndl_flag            ;restore original state
0460 BAE6 97 46                 sta   [temp_handle],y
0461 BAE8              @skip_temp  
0462 BAE8 A5 78                 lda   user_id_handle           ;lock ID table down
0463 BAEA 05 7A                 ora   user_id_handle+2
0464 BAEC F0 05                 beq   @skip_ids
0465 BAEE
0466 BAEE AD 23 BB              lda   user_id_flag
0467 BAF1 97 78                 sta   [user_id_handle],y
0468 BAF3              @skip_ids  
0469 BAF3 A5 90                 lda   reloc_handle
0470 BAF5 05 92                 ora   reloc_handle+2
0471 BAF7 F0 05                 beq   @skip_reloc
0472 BAF9
0473 BAF9 AD 1D BB              lda   relocHndl_flag           ;restore orig state
0474 BAFC 97 90                 sta   [reloc_handle],y
0475 BAFE              @skip_reloc  
0476 BAFE A5 94                 lda   seg_handle
0477 BB00 05 96                 ora   seg_handle+2
0478 BB02 F0 05                 beq   @skip_seg
0479 BB04
0480 BB04 AD 1F BB              lda   segHndl_flag             ;do the restore
0481 BB07 97 94                 sta   [seg_handle],y
0482 BB09              @skip_seg  
0483 BB09 A5 98                 lda   curr_id_handle
0484 BB0B 05 9A                 ora   curr_id_handle+2
0485 BB0D F0 05                 beq   @skip_id
0486 BB0F
0487 BB0F AD 21 BB              lda   idHndl_flag              ;do the restore
0488 BB12 97 98                 sta   [curr_id_handle],y
0489 BB14              @skip_id  
0490 BB14              end_handles  
0491 BB14 7A                    ply   
0492 BB15 FA                    plx   
0493 BB16 68                    pla   
0494 BB17 28                    plp                            ;restore original registers
0495 BB18 60                    rts   
0496 BB19
0497 BB19
0498 BB19 00 80        ExpressHndl_flag DC W:00
0499 BB1B 00 80        tempHndl_flag DC W:00
0500 BB1D 00 80        relocHndl_flag DC W:00
0501 BB1F 18 C0        segHndl_flag DC W:00
0502 BB21 00 00        idHndl_flag DC W:00
0503 BB23 00 00        user_id_flag DC W:00
0504 BB25
0505 BB25                       endp 
